<?php
/*--------------------------------------------------------------------------------------------------
    StyleEditProductSearchByTermEndpoint.php 2019-08-30
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2019 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\StyleEdit\Shop\Classes\Controllers\Endpoints;

use Gambio\StyleEdit\Configurations\ShopBaseUrl;
use Gambio\StyleEdit\ConfigurationValueInterface;

/**
 * Class StyleEditProductSearchByTrmEndpoint
 * @package Gambio\StyleEdit\Shop\Classes\Controllers
 */
class StyleEditProductSearchByTermEndpoint implements ConfigurationValueInterface
{
    /**
     * @return string
     */
    protected $baseUrl = '';
    
    
    /**
     * @return string
     */
    public function value(): string
    {
        return $this->baseUrl . '/admin/admin.php?do=StyleEditProductSearch/byTerm';
    }
    
    
    /**
     * StyleEditProductSearchByTermEndpoint constructor.
     *
     * @param ShopBaseUrl $url
     */
    public function __construct(ShopBaseUrl $url)
    {
        $this->baseUrl = $url->value();
    }
    
}
